### Name: PortfolioSlider
### Title: Portfolio Slider
### Aliases: PortfolioSlider weightsSlider frontierSlider
### Keywords: models

### ** Examples

## minvariancePortfolio -
   # Load Data and Convert to timeSeries Object:
   Data = as.timeSeries(data(smallcap.ts))
   Data = Data[, c("BKE", "GG", "GYMB", "KRON")]
   Data
   # Set Default Specifications:
   Spec = portfolioSpec()
   Spec
   # Allow for unlimited Short Selling:
   Constraints = "Short"
   # Compute Short Selling Minimum Variance Portfolio
   minvariancePortfolio(Data, Spec, Constraints)
    
## portfolioFrontier -
   # Modify Constraints - Now Long Only Constraints:
   Constraint = c("minW[1:nAssets]=0")
   # Calculation of the Efficient Frontier
   frontier = portfolioFrontier(Data, Spec, Constraint)
   print(frontier)
    
## frontierSlider -
   # Try Frontier Slider:
   # frontierSlider(frontier)

## weightsSlider -
   # Try Weights Slider:
   # weightsSlider(frontier)



