### Name: VaRModelling
### Title: Value-at-Risk Measures for Portfolios
### Aliases: VaRModelling pfolioVaR pfolioCVaR pfolioCVaRplus lambdaCVaR
###   pfolioMaxLoss pfolioReturn pfolioTargetReturn pfolioTargetRisk
###   pfolioSigma pfolioHist
### Keywords: math

### ** Examples

## assetsSim -
   myAssets = 100/12 * assetsSim(n = 120, dim = 4)
   # Plot Cumulated Returns of the Assets:
   prices = apply(myAssets, 2, FUN = cumsum)
   par(mfrow = c(2, 1), cex = 0.7)
   ts.plot(prices, col = 1:4, ylim = c(-300, 300))
   legend(0, 300, legend = colnames(myAssets), pch = "----", col = 1:4)
   title(main = "Cumulated Returns", ylab = "Cumulated Returns")
   abline(h = 0, lty = 3)
    
## pfolioCVaR -
   equalWeights = rep(1/4, 4)
   alpha = 0.10
   # Value at Risk:
   pfolioVaR(myAssets, equalWeights, alpha)
   # Conditional Value at Risk Plus:
   pfolioCVaRplus(myAssets, equalWeights, alpha)
   # Conditional Value at Risk Plus:
   pfolioCVaR(myAssets, equalWeights, alpha)
   # Lambda - Atomic Split Value:
   lambdaCVaR(120, alpha) 

## pfolioHist - 
   # Maximum Loss Value of the Portfolio
   pfolioMaxLoss(myAssets, equalWeights)
   # Compute Portfolio Returns:
   r = pfolioReturn(myAssets, equalWeights) 
   head(r)
   # Target Return and Target Risk:
   pfolioTargetReturn(myAssets, equalWeights)
   pfolioTargetRisk(myAssets, equalWeights)
   # Plot:
   pfolioHist(myAssets, equalWeights, alpha, n = 20)    



