### Name: as
### Title: timeSeries Class, Coercion and Transformation
### Aliases: as is.timeSeries as.timeSeries as.timeSeries.default
###   as.timeSeries.numeric as.timeSeries.data.frame as.timeSeries.matrix
###   as.timeSeries.ts as.timeSeries.character as.timeSeries.zoo
###   as.vector.timeSeries as.matrix.timeSeries as.data.frame.timeSeries
###   as.ts.timeSeries
### Keywords: chron

### ** Examples

## data - timeSeries:
   # Create an artificial timeSeries object:
   myFinCenter <<- "GMT"
   charvec = timeCalendar()
   data = matrix(rnorm(12))
   TS = timeSeries(data, charvec, units = "RAND")
   TS

## Test for timeSeries:
   is.timeSeries(TS)
   
## As Vector:
   as.vector(TS)
   
## As Matrix or Data Frame:
   as.matrix(TS)
   as.data.frame(TS)
   
## As Univariate Object of Class 'ts':
   as.ts(TS)



