### Name: SpecialDailySeries
### Title: SpecialDailySeries
### Aliases: dummyDailySeries alignDailySeries rollDailySeries
###   ohlcDailyPlot
### Keywords: chron

### ** Examples

## data - Data Frame:
   # To work with daily data, the best choice is "GMT"
   myFinCenter <<- "GMT"
   MSFT = as.timeSeries(data(msft.dat))
   head(MSFT)   
   
    
## Align Daily Series - 
   # Cut out April Data from 2001:
   Close = MSFT[, "Close"]
   tsApril01 = window(Close, "2001-04-01", "2001-04-30") 
   tsApril01    
   # Align with NA:
   tsRet = returnSeries(tsApril01, trim = TRUE)
   GoodFriday(2001)   
   EasterMonday(2001) 
   alignDailySeries(tsRet, method = "fillNA", include.weekends = FALSE)
   alignDailySeries(tsRet, method = "fillNA", include.weekends = TRUE)
   # Interpolate:
   alignDailySeries(tsRet, method = "interp", include.weekend = FALSE)
   alignDailySeries(tsRet, method = "interp", include.weekend = TRUE)
   
## ohlcDailyPlot -
   # ohlcDailyPlot(Close)



