### Name: model.fram
### Title: Model Frames for timeSeries Objects
### Aliases: model.frame model.frame.timeSeries
### Keywords: chron

### ** Examples

## data -  
   # Microsoft Data: 
   myFinCenter <<- "GMT"
   MSFT = as.timeSeries(data(msft.dat))[1:12, ]

## model.frame -
   # Extract High's and Low's:
   model.frame( ~ High + Low, data = MSFT)
   # Extract Open Prices and their log10's:
   base = 10
   Open = model.frame(Open ~ log(Open, base = `base`), data = MSFT)
   colnames(Open) <- c("MSFT", "log10(MSFT)")
   Open
    



