### Name: TimeSeriesClass
### Title: timeSeries Class
### Aliases: TimeSeriesClass timeSeries timeSeries-class readSeries
###   applySeries orderStatistics seriesData isUnivariate isMultivariate
### Keywords: chron

### ** Examples

## data -  
   # Microsoft Data: 
   myFinCenter <<- "GMT"
   MSFT = as.timeSeries(data(msft.dat))
   head(MSFT)

## timeSeries -  
   # Create a timeSeries Objec - The Direct Way ...
   Close = MSFT[, 5]
   head(Close)
   # From Scratch ...
   data = as.matrix(MSFT[, 4])
   charvec = rownames(MSFT)
   Close = timeSeries(data, charvec, units = "Close")
   head(Close)
   c(start(Close), end(Close))
    
## window  -    
   # Cut out April Data from 2001:
   tsApril01 = window(Close, "2001-04-01", "2001-04-30") 
   tsApril01

## returnSeries -  
   # Compute Returns:
   args(returnSeries)
   # Continuous Returns:
   returnSeries(tsApril01)
   # Discrete Returns:
   returnSeries(tsApril01, type = "discrete")
   # Don't trim:
   returnSeries(tsApril01, trim = FALSE)
   # Use Percentage Values:
   tsRet = returnSeries(tsApril01, percentage = TRUE, trim = FALSE)
   tsRet
     
## applySeries -   
   # Aggregate weekly:
   GoodFriday(2001)
   to = timeSequence(from = "2001-04-11", length.out = 3, by = "week") 
   from = to - 6*24*3600
   from
   to
   applySeries(tsRet, from, to, FUN = sum)



