### Name: fdrtool
### Title: Estimate (Local) False Discovery Rates For Diverse Test
###   Statistics
### Aliases: fdrtool
### Keywords: htest

### ** Examples

# load "fdrtool" library and p-values
library("fdrtool")
data(pvalues)

# estimate fdr and Fdr from p-values

data(pvalues)
fdr <- fdrtool(pvalues, statistic="pvalue")
fdr$qval # estimated Fdr values 
fdr$lfdr # estimated local fdr 

# estimate fdr and Fdr from z-scores

sd.true = 2.232
n = 500
z = rnorm(n, sd=sd.true)
z = c(z, runif(30, 5, 10)) # add some contamination
fdr <- fdrtool(z)

# you may change some parameters of the underlying functions
fdr <- fdrtool(z, cutoff.method="pct0", pct0=0.9) 



