### Name: conversion
### Title: Convert S3 Partition Objects to KCCA
### Aliases: as.kcca as.kcca.kmeans as.kcca.partition
### Keywords: cluster

### ** Examples

data(Nclus)

cl1 = kmeans(Nclus, 4)
cl1
cl1a = as.kcca(cl1, Nclus)
cl1a

## Don't show:
stopifnot(all.equal(cl1$cluster, cluster(cl1a)))
## End Don't show

library("cluster")
cl2 = pam(Nclus, 4)
cl2
cl2a = as.kcca(cl2)
cl2a
## the same
cl2b = as.kcca(cl2, Nclus)
cl2b

## Don't show:
stopifnot(all.equal(cluster(cl2a), cluster(cl2b)))
stopifnot(all.equal(parameters(cl2a), parameters(cl2b)))
## End Don't show



