### Name: determinism
### Title: Detecting determinism in a time series
### Aliases: determinism eda.plot.determinism plot.determinism
###   print.determinism summary.determinism
### Keywords: univar models nonlinear

### ** Examples

## perform a determinism test for the beamchaos 
## series. in order to do so, it is vitally 
## important to provide the proper orbital lag, 
## which can be estimated as the lag value 
## associated with the first common maxima over 
## all contours in a spaceTime plot. 
plot(spaceTime(beamchaos))

## we esimate an appropriate olag of 30, and 
## subsequently perform the deterrminism test 
beam.det <- determinism(beamchaos, olag=30)
print(beam.det)
plot(beam.det)

eda.plot(beam.det)

## perform a similar analysis for a Gaussian white 
## noise realization 
rnorm.det <- determinism(rnorm(1024),olag=1)
print(rnorm.det)
plot(rnorm.det)

eda.plot(rnorm.det)



