### Name: localProjection
### Title: Time series denoising via a local projection filtering technique
### Aliases: localProjection
### Keywords: univar models nonlinear

### ** Examples

x      <- beamchaos@data
x      <- x - mean(x)
sigma  <- stdev(x)
xnoise <- x + rnorm(length(x)) * sigma / 3
xclean <- localProjection(xnoise, dimension=7, noise.dimension=5,
    max.distance=3*sigma, n.neighbor=100)

y <- data.frame(xclean, xnoise, x)
stackPlot(x=positions(beamchaos)[], y=y,
    ylab=c("denoised","noisy","original"),
    ylim=range(y))



