### Name: gmData
### Title: Class "gmData" graphical meta data
### Aliases: newgmData as.gmData as.gmData.array as.gmData.data.frame
###   as.gmData.table latent latent.gmData latent<- latent<-.gmData nLevels
###   nLevels.gmData nLevels<- nLevels<-.gmData description
###   description.gmData description<- description<-.gmData obs
###   observations observations.gmData observations<- observations<-.gmData
###   print.gmData shortNames shortNames.gmData shortNames<-
###   shortNames<-.gmData summary.gmData valueLabels valueLabels.gmData
###   valueLabels<- valueLabels<-.gmData varNames varNames.gmData
###   varNames<- varNames<-.gmData varTypes varTypes.gmData varTypes<-
###   varTypes<-.gmData dataOrigin dataOrigin.gmData ordinal<-
###   ordinal<-.gmData ordinal ordinal.gmData nominal<- nominal<-.gmData
###   nominal nominal.gmData
### Keywords: models

### ** Examples


vn <- c("a","b","c","d")
z<-newgmData(vn,varTypes=c("dis","dis","con","con"))
summary(z)
z<-newgmData(vn,varTypes=c("dis","dis","con","con"),nLevels=c(4,3,NA,NA))
summary(z)
z<-newgmData(vn,varTypes=c("dis","dis","con","con"),nLevels=c(4,NA,NA,NA))
summary(z)
z<-newgmData(vn,varTypes=c("dis","dis","ord","con"),valueLabels=list("a"=1:2, "b"=1:4))
summary(z)

ccnames <- c("asia", "smoke", "tub", "lung", "bronc", "either", "xray", "dysp")
gmd <- newgmData(ccnames,valueLabels=c("yes","no"), description="Chest clinic")
summary(gmd)

data(mathmark)
as.gmData(mathmark)

data(HairEyeColor)
as.gmData(HairEyeColor)




