### Name: ci.eval
### Title: Function that evaluates the cindex of a classifier function on a
###   data frame
### Aliases: ci.eval
### Keywords: misc

### ** Examples

## The function is currently defined as
## Not run: 
##D function (cf, df, ...) 
##D {
##D     clsv <- unlist(df[, ncol(df)])
##D     clss <- unique(clsv)
##D     if (length(clss) != 2) 
##D         stop("Cannot compute CI on non-binary outcomes. Aborting.\n", 
##D             call. = F)
##D     clss <- sort(clss)
##D     cs <- cf(df, ...)
##D     if (is.null(cs)) 
##D         return(NULL)
##D     csc <- colnames(cs)
##D     prev <- sum(clsv == clss[2])/length(clsv)
##D     csn <- t(apply(cs, 1, pnormalize, c(1 - prev, prev)))
##D     pred <- csn[, 2]
##D     act <- clsv == clss[2]
##D     return(cindex(pred, act)[1])
##D   }
## End(Not run)



