### Name: gcl
### Title: GCL: a fuzzy rule classifier generator
### Aliases: gcl sgcl tcl
### Keywords: classif tree

### ** Examples

## run the demo
demo(gcldemo)

## play with the iris data set:
## Not run: 
##D library(datasets)
##D data(iris)
##D classifier <- gcl(iris, nlev=5)
##D acc.eval(classifier, iris)
## End(Not run)

## compare performance of gcl and tcl
## Not run: 
##D library(datasets)
##D data(iris)
##D cv52(iris, gcl, tcl, acc.eval, nlev=5, t.nlev=5)
## End(Not run)

## or a little more complex
library(gcl)
count <- matrix(c(0,0,0,1,1,0,1,1),ncol=2,byrow=TRUE)
xordata <- cbind(count, apply(count, 1, function(x) xor(x[1],x[2])))
colnames(xordata) <- c("Bit.1", "Bit.2", "XOR")
cf <- gcl(xordata,2,c())
cat(cf())
## Not run: 
##D # should produce something like:
##D Generated by gcl v1.06c Sat Nov 12 19:25:12 2005.
##D  nlev=2, filtering: no filtering took place
##D  rule generation: no subsampling.
##D  (c) Copyright 2005, Staal Vinterbo, all rights reserved.
##D Bit.1=2 & Bit.2=2 => XOR=0 [ 0 1 Inf ],[ 0 1 Inf ]
##D Bit.1=2 & Bit.2=1 => XOR=1 [ 0 1 Inf ],[ -Inf 0 1 ]
##D Bit.1=1 & Bit.2=2 => XOR=1 [ -Inf 0 1 ],[ 0 1 Inf ]
##D Bit.1=1 & Bit.2=1 => XOR=0 [ -Inf 0 1 ],[ -Inf 0 1 ]
## End(Not run)
v <- c(0,1)
names(v) <- colnames(xordata)[1:2]
cf(v)
## Not run: 
##D # produces:
##D             0 1
##D        [1,] 0 1
##D dump("cf", "cf.r")
##D rm(cf)
##D source("cf.r")
##D cf(v)
##D # produces:
##D             0 1
##D        [1,] 0 1
## End(Not run)



