### Name: write.fwf
### Title: Write object in fixed width format
### Aliases: write.fwf
### Keywords: print file

### ** Examples


  ## Some data
  testData <- data.frame(num1=c(1:10, NA),
                         num2=c(NA, seq(from=1, to=5.5, by=0.5)),
                         num3=c(NA, rnorm(n=10, mean=1e6, sd=3e5)),
                         int1=c(as.integer(1:4), NA, as.integer(5:10)),
                         fac1=factor(c(NA, letters[1:10])),
                         fac2=factor(c(letters[6:15], NA)),
                         cha1=c(letters[17:26], NA),
                         cha2=c(NA, letters[26:17]),
                         stringsAsFactors=FALSE)
  levels(testData$fac1) <- c(levels(testData$fac1), "unusedLevel")
  testData$Date <- as.Date("1900-1-1")
  testData$Date[2] <- NA
  testData$POSIXt <- as.POSIXct(strptime("1900-1-1 01:01:01",
                                         format="%Y-%m-%d %H:%M:%S"))
  testData$POSIXt[5] <- NA

  ## Default
  write.fwf(x=testData)

  ## NA should be - or ------------
  write.fwf(x=testData, na="-")
  write.fwf(x=testData, na="------------")

  ## Some other separator than space
  write.fwf(x=testData[, 1:4], sep="-mySep-")

  ## Write to file and report format and fixed width information
  file <- tempfile("test.txt")
  formatInfo <- write.fwf(x=testData, file=file, formatInfo=TRUE)

  ## Read exported data back to R (note +1 due to separator)
  ## ... without header
  read.fwf(file=file, widths=formatInfo$width + 1, header=FALSE, skip=1,
           strip.white=TRUE)

  ## ... with header - via postimport modfication
  tmp <- read.fwf(file=file, widths=formatInfo$width + 1, skip=1,
                  strip.white=TRUE)
  colnames(tmp) <- read.table(file=file, nrow=1, as.is=TRUE)
  tmp

  ## ... with header - persuading read.fwf to accept header properly
  ## (thanks to Marc Schwartz)
  read.fwf(file=file, widths=formatInfo$width + 1, strip.white=TRUE,
           skip=1, col.names=read.table(file=file, nrow=1, as.is=TRUE))

  ## ... with header - with the use of quotes
  write.fwf(x=testData, file=file, quote=TRUE)
  read.table(file=file, header=TRUE, strip.white=TRUE)

  ## Tidy up
  unlink(file)



