### Name: .build_options
### Title: Set ggplot options
### Aliases: .build_options ggopt theme_default theme_bw
### Keywords: manip

### ** Examples
ggopt(background.fill = "black", background.color ="white") # all new plots will use this
p <- qplot(total_bill, tip, facet = smoker ~ sex, data=tips)
p
p$background.fill = "white"
p
p$strip.text.gp <- gpar(col="red", fontsize=15)
p$strip.gp <- gpar(fill="black")
p$background.fill <- "black"
p$background.colour <- "white"
p$grid.colour <- "white"
p$grid.fill <- "grey50"
p # a very ugly plot!
ggopt(background.fill = "white", background.color ="black")

p <- qplot(wt, mpg, data=mtcars, colour=factor(cyl))
p$legend.position <- c(0.9,0.9); p
p$legend.position <- c(0.5,0.5)
p$legend.justification <- "center"
p

DF <- data.frame(
x=rnorm(20), 
y=rnorm(20), 
g1=rep(letters[1:2], 10),
g2=rep(LETTERS[1:2], each=10)
)

(p <- qplot(x, y, data=DF, facets = g1 ~ g2))

p$strip.text <- function (variable, value) {
greek <- c("A" = "alpha", "B" = "beta")[value]
makelabel <- function (g) substitute(variable == greek, list(variable=as.name(variable), greek=as.name(g)))

lapply(greek, makelabel)
}

p


