### Name: qplot
### Title: Quick plot.
### Aliases: qplot
### Keywords: hplot

### ** Examples
# Use data from data.frame
qplot(mpg, wt, data=mtcars)
qplot(mpg, wt, data=mtcars, colour=cyl)
qplot(mpg, wt, data=mtcars, size=cyl)
qplot(mpg, wt, data=mtcars, facets=vs ~ am)

# Use data from workspace environment
attach(mtcars)
qplot(mpg, wt)
qplot(mpg, wt, colour=cyl)
qplot(mpg, wt, size=cyl)
qplot(mpg, wt, facets=vs ~ am)

# Use different geoms
qplot(mpg, wt, geom="path")
qplot(factor(cyl), wt, geom=c("boxplot", "jitter"))


