### Name: ggarea
### Title: Grob function: area
### Aliases: ggarea
### Keywords: hplot internal

### ** Examples
huron <- data.frame(year = 1875:1972, level = as.vector(LakeHuron))
p <- ggplot(huron, aes=list(y=level, x=year))
ggarea(p)
ggarea(p, colour="black")
ggline(ggarea(p)) # better
qplot(year, level, data=huron, type=c("area", "line"))
ggarea(p, fill=alpha("grey80", 0.5))
pscontinuous(ggarea(p), "y", range=c(0,NA))


