### Name: ggbar
### Title: Grob function: bars
### Aliases: ggbar
### Keywords: hplot

### ** Examples
cyltab <- as.data.frame(table(cyl=mtcars$cyl))
p <- ggplot(cyltab, aes=list(y=Freq, x=cyl))
ggbar(p)
ggbar(p, fill="white", colour="red")
#Can also make a stacked bar chart
p <- ggplot(mtcars, aes=list(y=1, x=factor(cyl)))
ggbar(p, avoid="stack")
ggbar(p, avoid="stack", colour="red") # Made up of multiple small bars
p <- ggplot(mtcars, aes=list(y=mpg, x=factor(cyl)))
ggbar(p, avoid="stack")
ggbar(p, avoid="dodge", sort=TRUE)
ggbar(p, aes=list(fill=mpg), avoid="dodge", sort=TRUE)
ggbar(p, avoid="stack", sort=TRUE)


