### Name: ggplot.default
### Title: Create a new plot
### Aliases: ggplot.default package-ggplot ggplot
### Keywords: hplot

### ** Examples
p <- ggplot(tips)
summary(p)
ggpoint(p, aesthetic=list(y = tip, x=total_bill))
p <- ggplot(tips, aesthetic=list(y = tip, x=total_bill))
p$title <- "Tips"
summary(p)
ggpoint(p)
ggpoint(p, colour="darkgreen", size=3)
ggpoint(p, list(colour=sex))
ggpoint(ggplot(tips, . ~ sex,aesthetics = list(y = tip, x = total_bill)))
p <- ggplot(tips, smoker ~ sex,aesthetics = list(y = tip, x = total_bill))
ggpoint(p)
ggsmooth(ggpoint(p))
ggsmooth(ggpoint(p), method=lm, formula=y~x)
ggabline(ggpoint(p), slope=c(0.1,0.15,0.2))
(p2 <- ggabline(ggpoint(p, aes=list(colour=tip/total_bill)), slope=c(0.1,0.15,0.2)))
summary(p2)
scgradient(p2)
scgradient(p2, midpoint=0.15, high="green", mid="yellow")

p<-ggplot(tips, sex ~ smoker, aesthetics=list(x=tip/total_bill), margins=TRUE)
gghistogram(p)
gghistogram(p,scale="density", breaks=seq(0,1, length=20))
ggdensity(gghistogram(p))

p<-ggplot(tips, . ~ smoker, aesthetics=list(x=sex, y=tip))
ggboxplot(p)
ggjitter(ggboxplot(p))


