### Name: ggribbon
### Title: Grob function: ribbon
### Aliases: ggribbon
### Keywords: hplot

### ** Examples
mry <- do.call(rbind, by(movies, round(movies$rating), function(df) { 
nums <- tapply(df$length, df$year, length)
data.frame(rating=round(df$rating[1]), year = as.numeric(names(nums)), number=as.vector(nums))
}))
p <- ggplot(mry, aesthetics = list(x=year, y=number, id=rating))
ggribbon(p, aes=list(upper=number+5, lower=number-5), fill="white", colour=NA)
ggribbon(p, aes=list(y=number, plus=5, minus=-5), fill="white", colour=NA)
ggribbon(p, aes=list(upper=number*1.1, lower=number*0.9), fill="white", colour=NA)
ggribbon(p, aes=list(upper=number+5, lower=number-5), fill="pink")
ggribbon(p, aes=list(upper=number+5, lower=number-5, fill=rating), colour=NA)
scfillgradient(ggribbon(p, aes=list(upper=number+5, lower=number-5, fill=rating), colour=NA), midpoint=5, low="red", high="darkgreen")


