### Name: ghyp-data
### Title: Get methods for objects inheriting from class ghypbase
### Aliases: ghyp.data ghyp.fit.info
### Keywords: utilities

### ** Examples

  ## multivariate generalized hyperbolic distribution
  ghyp.mv <- ghyp(lambda = 1, alpha.bar = 0.1, mu = rep(0, 2), sigma = diag(rep(1, 2)), 
                  gamma = rep(0, 2), data = matrix(rt(1000, df = 4), ncol = 2))

  ## Get data
  ghyp.data(ghyp.mv)

  ## 'ghyp.fit.info' does only work when the object is of class 'mle.ghyp',
  ## i.e. is created by 'fit.ghypuv' etc.
  mv.fit <- fit.tmv(data = ghyp.data(ghyp.mv), control = list(abs.tol = 1e-3))
  ghyp.fit.info(mv.fit)



