### Name: portfolio.optimize
### Title: Portfolio optimization given a multivariate generalized
###   hyperbolic distribution
### Aliases: portfolio.optimize
### Keywords: optimize multivariate iteration

### ** Examples

  data(smi.stocks)
  
  mv.fit <- fit.ghypmv(data = smi.stocks[, 2:6], opt.pars = c(lambda = FALSE), 
                       lambda = 2, control = list(rel.tol = 1e-5, abs.tol = 1e-5))

  optimal.portfolio <- portfolio.optimize(mv.fit, ptf.mean = 1e-3, 
                                          risk.measure = "expected-shortfall",
                                          level = 0.99)

  plot(optimal.portfolio$portfolio, type = "l" , col = "red")
  ## Not run: 
##D   lines(density(smi.stocks[, 2:6] 
##D   
## End(Not run)



