### Name: bigz
### Title: Large sized integer values
### Aliases: bigz as.bigz as.character.bigz as.double.bigz print.bigz
###   is.na.bigz
### Keywords: arith

### ** Examples

## 1+1=2
a = as.bigz(1)
a + a

## Not run: 
##D ## calculate c = x^e mod n
##D x <- as.bigz("0x123456789abcdef") # my secret message
##D e <- as.bigz(3) # something smelling like a dangerous public RSA exponent
##D n <- as.bigz("0x4378a27...")  # probably a product of two primes
##D 
##D # first way to do it right
##D modulus(x) <- n
##D c <- x ^ e
##D 
##D # similar second way (maybe more sensefull if you reuse e) to do it right
##D modulus(e) <- n
##D c <- x ^ e
##D 
##D # third way to do it right
##D c <- x ^ as.bigz(e, n)
##D 
##D # WRONG! (although very beautiful. Maybe ok for small examples)
##D c <- x ^ e 
##D 
##D # Return result in hexa
##D as.character(c,b=16)
## End(Not run)



