### Name: heatmap.2
### Title: Draw a Heat Map
### Aliases: heatmap.2
### Keywords: hplot

### ** Examples

 library(gplots)
 data(mtcars)
 x  <- as.matrix(mtcars)
 rc <- rainbow(nrow(x), start=0, end=.3)
 cc <- rainbow(ncol(x), start=0, end=.3)

 heatmap.2(x)  ## default - dendrogram plotted and reordering done. 
 heatmap.2(x, dendrogram="none") ##  no dendrogram plotted, but reordering done.
 heatmap.2(x, dendrogram="row") ## row dendrogram plotted and row reordering done.
 heatmap.2(x, dendrogram="col") ## col dendrogram plotted and col reordering done.

 heatmap.2(x, keysize=2)  ## default - dendrogram plotted and reordering done.

 heatmap.2(x, Rowv=FALSE, dendrogram="both") ## generate warning!
 heatmap.2(x, Rowv=NULL, dendrogram="both")  ## generate warning!
 heatmap.2(x, Colv=FALSE, dendrogram="both") ## generate warning!



 hv <- heatmap.2(x, col=cm.colors(256), scale="column", 
               RowSideColors=rc, ColSideColors=cc, margin=c(5, 10), 
               xlab="specification variables", ylab= "Car Models", 
               main="heatmap(<Mtcars data>, ..., scale=\"column\")", 
               tracecol="green", density="density")

 str(hv) # the two re-ordering index vectors

 data(attitude)
 round(Ca <- cor(attitude), 2)
 symnum(Ca) # simple graphic

 # with reorder
 heatmap.2(Ca,           symm=TRUE, margin=c(6, 6), trace="none" )

 # without reorder
 heatmap.2(Ca, Rowv=FALSE, symm=TRUE, margin=c(6, 6), trace="none" )

 ## For variable clustering, rather use distance based on cor():
 data(USJudgeRatings)
 symnum( cU <- cor(USJudgeRatings) )

 hU <- heatmap.2(cU, Rowv=FALSE, symm=TRUE, col=topo.colors(16), 
              distfun=function(c) as.dist(1 - c), trace="none")

 ## The Correlation matrix with same reordering:
 hM <- format(round(cU, 2))
 hM

 # now with the correlation matrix on the plot itself

 heatmap.2(cU, Rowv=FALSE, symm=TRUE, col=rev(heat.colors(16)), 
             distfun=function(c) as.dist(1 - c), trace="none", 
             cellnote=hM)

 ## genechip data examples
 ## Not run: 
##D  library(affy)
##D  data(SpikeIn)
##D  pms <- SpikeIn@pm
##D 
##D  # just the data, scaled across rows
##D  heatmap.2(pms, col=rev(heat.colors(16)), main="SpikeIn@pm", 
##D               xlab="Relative Concentration", ylab="Probeset", 
##D               scale="row")
##D 
##D  # fold change vs "12.50" sample
##D  data <- pms / pms[, "12.50"]
##D  data <- ifelse(data>1, data, -1/data)
##D  heatmap.2(data, breaks=16, col=redgreen, tracecol="blue", 
##D                main="SpikeIn@pm Fold Changes\nrelative to 12.50 sample", 
##D                xlab="Relative Concentration", ylab="Probeset")
##D  
## End(Not run)



