### Name: sandcov
### Title: Compute Sandwich Variance-Covariance Estimates
### Aliases: sandcov
### Keywords: models regression

### ** Examples


data(renin)

## Fit a model for covariate effects.

m1 <- glm(case ~ age + factor(race) + gender, family=binomial(link=logit))

## Obtain sandwich variance-covariance matrix.

id <- 1:length(case)
v1 <- sandcov(model = m1, id = id)

## Calculate robust standard error estimates.

se1 <- sqrt(diag(v1))

## Fit a model for haplotype and covariate effects.

m2 <- haplo.ccs(case ~ gender + age + factor(race) + haplo(geno))

## Obtain sandwich variance-covariance matrix by one of two methods.

v2 <- m2$covariance
v2 <- vcov(m2)

## Calculate robust standard error estimates.

se2 <- sqrt(diag(v2))




