### Name: icommunity
### Title: Identification of Communities or Modules in a Network
### Aliases: icommunity
### Keywords: graphs misc

### ** Examples

## load example networks 
data(icashflow)

## community identification
cluster3 <- icommunity(cf3,labelcf3,partite=FALSE)
## network plotting
inetplot(cluster3,shaft=2,circle=FALSE,theta=33,points=FALSE)

## poly-partite partition
partite3 <- icommunity(cf3,labelcf3,partite=TRUE)
## plot the multi-partite graph
inetplot(partite3,shaft=10,circle=FALSE,theta=33,points=FALSE)

## to extract the community members:
partite3_community <- numeric()
for (i in 1:length(partite3$sizes)) { # loop over no. of communities
    partite3_community <- c(partite3_community,rep(i,partite3$sizes[i]))
}
for (i in 1:length(partite3$sizes)) { 
    print(c(paste("community",as.character(i),"="),partite3$indivisibles[which(partite3_community == i)]))
}
## the ringleadership scores of the nodes are extracted in the same fashion



