### Name: ld.sim
### Title: Functions to simulate populations with a bi-allelic marker and
###   QTL in linkage disequilibrium and test for association.
### Aliases: ld.sim ld.sim1
### Keywords: design

### ** Examples

# Power from stochastic simulation for Luo's population 12
data(luo.ld.populations)
luo.pop12.sim <- ld.sim(nsim=3000,
                        n=luo.ld.populations[12,"n"],
                        p=luo.ld.populations[12,"p"],
                        q=luo.ld.populations[12,"q"],
                        D=luo.ld.populations[12,"D"],
                        h2=luo.ld.populations[12,"h2"],
                        phi=luo.ld.populations[12,"phi"],
                        Vp=100)
# power
table(luo.pop12.sim[,4] < 0.05)[2]/sum(table(luo.pop12.sim[,4] < 0.05))
# Cf power from deterministic calculation
luo.ld.power(n=luo.ld.populations[12,"n"],
             p=luo.ld.populations[12,"p"],
             q=luo.ld.populations[12,"q"],
             D=luo.ld.populations[12,"D"],
             h2=luo.ld.populations[12,"h2"],
             phi=luo.ld.populations[12,"phi"],
             Vp=100,
             alpha=0.05)



