### Name: luo.ld.power
### Title: Classical deterministic power calculation for association
###   studies to detect linkage disequilibrium
### Aliases: luo.ld.power
### Keywords: design

### ** Examples

data(luo.ld.populations)
options(digits=3)
powers <- numeric(nrow(luo.ld.populations))
for(ii in 1:nrow(luo.ld.populations)){
   cat("ii=",ii,"\n")
   powers[ii] <- luo.ld.power(n=luo.ld.populations[ii,"n"],
                              p=luo.ld.populations[ii,"p"],
                              q=luo.ld.populations[ii,"q"],
                              D=luo.ld.populations[ii,"D"],
                              h2=luo.ld.populations[ii,"h2"],
                              phi=luo.ld.populations[ii,"phi"],
                              Vp=100,
                              alpha=0.05)
}
cbind(luo.ld.populations,power=powers)



