### Name: oneway.bf.alpha
### Title: Correspondence between significance levels and Bayes factors for
###   effects of marker genotype classes.
### Aliases: oneway.bf.alpha oneway.bf.alpha.required
### Keywords: htest models

### ** Examples

# calculations for Table 4 in the manuscript
data(luo.ld.populations)
Bs <- numeric(nrow(luo.ld.populations))
n.Bf20s <- numeric(nrow(luo.ld.populations))
ns <- c(seq(200,400,by=25),450,seq(500,4000,by=100))
powers <- numeric(length(ns))
alphas <- numeric(length(ns))
P.Bf20s <- numeric(length(ns))
for(ii in 1:nrow(luo.ld.populations)){
   cat("ii=",ii,"\n")
   powers[ii] <- luo.ld.power(n=luo.ld.populations[ii,"n"],
                              p=luo.ld.populations[ii,"p"],
                              q=luo.ld.populations[ii,"q"],
                              D=luo.ld.populations[ii,"D"],
                              h2=luo.ld.populations[ii,"h2"],
                              phi=luo.ld.populations[ii,"phi"],
                              Vp=100,
                              alpha=0.05)

   p1 <- luo.ld.populations[ii,"p"]
   Bs[ii] <- oneway.bf.alpha(n=luo.ld.populations[ii,"n"],
                 group.sizes=c(p1^2,2*p1*(1-p1),(1-p1)^2)*
                                 luo.ld.populations[ii,"n"])
   for(jj in seq(along=ns)){
     alphas[jj] <- oneway.bf.alpha.required(ns[jj],
                       group.sizes=c(p1^2,2*p1*(1-p1),(1-p1)^2)*ns[jj],Bf=20)
     P.Bf20s[jj] <- luo.ld.power(n=ns[jj],
                                 p=luo.ld.populations[ii,"p"],
                                 luo.ld.populations[ii,"q"],
                                 D=luo.ld.populations[ii,"D"],
                                 h2=luo.ld.populations[ii,"h2"],
                                 phi=luo.ld.populations[ii,"phi"],
                                 Vp=100,
                                 alpha=alphas[jj],
                                 print.it=FALSE)
   }
   n.Bf20s[ii] <- approx(P.Bf20s,ns,xout=0.9)$y
   cat("n =",n.Bf20s[ii],"\n")
}
cbind(luo.ld.populations,powers,n.Bf20s)




