### Name: lga
### Title: Perform LGA
### Aliases: lga
### Keywords: multivariate

### ** Examples


## Synthetic Data
## Make a dataset with 2 clusters in 2 dimensions

library(MASS)
set.seed(1234)
X <- rbind(mvrnorm(n=100, mu=c(1,-1), Sigma=diag(0.1,2)+0.9),
            mvrnorm(n=100, mu=c(1,1), Sigma=diag(0.1,2)+0.9))

lgaout <- lga(X,2)
plot(lgaout)
print(lgaout)

## nhl94 data set

data(nhl94)
plot(lga(nhl94, k=3, niter=30))

## Allometry data set
data(brain)
plot(lga(log(brain, base=10), k=3))

## Second Allometry data set
data(ob)
plot(lga(log(ob[,2:3]), k=3), pch=as.character(ob[,1]))

## Parallel processing case
## In this example, running using 4 nodes. 

## Not run: 
##D set.seed(1234)
##D X <- rbind(mvrnorm(n=1e6, mu=c(1,-1), Sigma=diag(0.1,2)+0.9),
##D             mvrnorm(n=1e6, mu=c(1,1), Sigma=diag(0.1,2)+0.9))
##D abc <- lga(X, k=2, nnode=4)
## End(Not run)




