### Name: coeftest
### Title: Testing Estimated Coefficients
### Aliases: coeftest coeftest.default coeftest.survreg coeftest.glm
###   coeftest.breakpointsfull print.coeftest
### Keywords: htest

### ** Examples

## load data and fit model
data(Mandible)
fm <- lm(length ~ age, data=Mandible, subset=(age <= 28))

## the following commands lead to the same tests:
summary(fm)
coeftest(fm)

## a z test (instead of a t test) can be performed by
coeftest(fm, df = Inf)

if(require(sandwich)) {
## a different covariance matrix can be also used:
## either supplied as a function
coeftest(fm, df = Inf, vcov = vcovHC)
## or as a matrix
coeftest(fm, df = Inf, vcov = vcovHC(fm, type = "HC0"))
}



