### Name: graphmod
### Title: Function to plot a graphical model.
### Aliases: graphmod graphmod.predlogilasso graphmod.cvlogilasso
###   graphmod.levellogilasso
### Keywords: hplot

### ** Examples

library(gRbase)
data(reinis)

fit <- logilasso(reinis,lambdainit=1)
pred <- predict(fit,lambda=0.5)
# Graphical model of an object of class predlogilasso
graphmod(pred,nnames=as.character(c(1:6)))

fit <- logilasso(reinis,lambdainit=1,cvfold=3)
# Graphical model of an object of class cvlogilasso
graphmod(fit,nnames=c("one","two","three","four","five","six"))


