### Name: levelcv
### Title: Cross-Validation for different interaction levels
### Aliases: levelcv
### Keywords: models

### ** Examples

library(gRbase)
data(reinis)
levellogi <- levelcv(reinis,lambdainit=1,lambdamin=0.1,from.which.int=1,to.which.int=3,cvfold=3)

## The methods predict, plot, traceplot and graphmod are defined for the resulting
## object of class cvlogilasso
predlevel <- predict(levellogi)
plot(predlevel)
traceplot(predlevel)
graphmod(predlevel)

### Different initialization: Y and combX
### 5 factors: All have 2 levels
### nlev would be c(2,2,2,2,2)
Y     <- c(4,1,3,2,9)
combX <- rbind(c(1,0,1,1,0),c(1,0,0,1,1),c(0,1,0,0,1),c(0,0,1,0,0),c(1,1,0,0,1))
### 4 observations wit level 1 of factor 1, level 0 of factor two, level 1 of factor
### 3 and so on.
levellogi2 <- levelcv(Y,combX=combX,from.which.int=1,to.which.int=3,cvfold=3)



