### Name: logilasso
### Title: Fits a log-linear model and/or performs cross-validation.
### Aliases: logilasso
### Keywords: models regression

### ** Examples

## Use logilasso on the reinis dataset provided in the
## package gRbase
library(gRbase)
data(reinis)

## Fit a log-linear model for lambdas between 1 and 0.1
## No cross-validation is performed
fit <- logilasso(reinis,lambdainit=1,lambdamin=0.1)

### Different initialization: Y and combX
### 5 factors: All have 2 levels
Y     <- c(4,1,3,2,9)
combX <- rbind(c(1,0,1,1,0),c(1,0,0,1,1),c(0,1,0,0,1),c(0,0,1,0,0),c(1,1,0,0,1))
### 4 observations wit level 1 of factor 1, level 0 of factor two, level 1 of factor
### 3 and so on.
### The rows of combX correspond to a the levels of the five factors
### Must be numeric with 0/1/2/... and so on.
fit2 <- logilasso(Y,combX)

## Trajectories from lambdainit to lambda optimal
plot(fit2)
traceplot(fit2)

## Predict functions
pred <- predict(fit,lambda=0.3)

## Perform 3-fold cross-validation
fitcv <- logilasso(reinis,lambdainit=1,lambdamin=0.1,cvfold=3)

## Plots a graphical model with the lambda calculated by cross-validation.
plot(fitcv)
graphmod(fitcv)
  
predcv <- predict(fitcv)



