### Name: predict.logilasso
### Title: Predicts the interaction vector beta of a loglinear interaction
###   model.
### Aliases: predict.logilasso predict.cvlogilasso predict.levellogilasso
### Keywords: methods

### ** Examples

library(gRbase)
data(reinis)

fit <- logilasso(reinis,lambdainit=1,lambdamin=0.1)
pred1 <- predict(fit,lambda=0.5)
pred2 <- predict(fit)

fitcv <- logilasso(reinis,lambdainit=1,lambdamin=0.1,cvfold=3)
predcv1 <- predict(fitcv)

levellogi <- levelcv(reinis,lambdainit=1,lambdamin=0.1,to.which.int=3,cvfold=3)
predlevel <- predict(levellogi)

## Methods plot and graphmod exist for all predicted models
## Except for pred2, there is no graphmod method, because no
## lambda was specified

plot(predcv1)
graphmod(predcv1)



