### Name: mclust1Dplot
### Title: Plot one-dimensional data modeled by an MVN mixture.
### Aliases: mclust1Dplot
### Keywords: cluster

### ** Examples

n <- 250 ## create artificial data
set.seed(1)
y <- c(rnorm(n,-5), rnorm(n,0), rnorm(n,5))
yclass <- c(rep(1,n), rep(2,n), rep(3,n))

yModel <- mclustModel(y, mclustBIC(y))

mclust1Dplot(y, parameters = yModel$parameters, z = yModel$z, 
             what = "classification", identify = TRUE)

mclust1Dplot(y, parameters = yModel$parameters, z = yModel$z, 
             truth = yclass, what = "errors", identify = TRUE)

mclust1Dplot(y, parameters = yModel$parameters, z = yModel$z, 
             what = "density", identify = TRUE)

mclust1Dplot(y, z = yModel$z, parameters = yModel$parameters,
            what = "uncertainty", identify = TRUE)




