### Name: plot.mclustDA
### Title: Plotting method for MclustDA discriminant analysis.
### Aliases: plot.mclustDA
### Keywords: cluster

### ** Examples

n <- 250 ## create artificial data
set.seed(1)
triModal <- c(rnorm(n,-5), rnorm(n,0), rnorm(n,5))
triClass <- c(rep(1,n), rep(2,n), rep(3,n))

odd <- seq(from = 1, to = length(triModal), by = 2)
even <- odd + 1
triMclustDA <- mclustDA(train=list(data=triModal[odd],labels=triClass[odd]),
                   test= list(data=triModal[even],labels=triClass[even]),
                       verbose = TRUE)

names(triMclustDA)
## Not run: 
##D   plot(triMclustDA, trainData = triModal[odd], testData = triModal[even])
## End(Not run)

odd <- seq(from = 1, to = nrow(cross), by = 2)
even <- odd + 1
crossMclustDA <- mclustDA( train=list(data=cross[odd,-1],
                                      labels=cross[odd,1]),
                       test= list(data=cross[even,-1],labels=cross[even,1]),
                       verbose = TRUE)

## Not run: 
##D   plot(crossMclustDA, trainData = cross[odd,-1], testData = cross[even,-1])
## End(Not run)

odd <- seq(from = 1, to = nrow(iris), by = 2)
even <- odd + 1
irisMclustDA <- mclustDA(train=list(data=iris[odd,-5],labels=iris[odd,5]),
                       test= list(data=iris[even,-5],labels=iris[even,5]),
                       verbose = TRUE)

## Not run: 
##D   plot(irisMclustDA, trainData = iris[odd,-5], testData = iris[even,-5])
## End(Not run)



