### Name: simE
### Title: Simulate from a Parameterized MVN Mixture Model
### Aliases: simE simV simEII simVII simEEI simVEI simEVI simVVI simEEE
###   simEEV simVEV simVVV
### Keywords: cluster

### ** Examples

d <- 2
G <- 2
scale <- 1
shape <- c(1, 9)

O1 <- diag(2)
O2 <- diag(2)[,c(2,1)]
O <- array(cbind(O1,O2), c(2, 2, 2))
O

variance <- list(d= d, G = G, scale = scale, shape = shape, orientation = O)
mu <- matrix(0, d, G) ## center at the origin
simdat <- simEEV( n = 200, 
                  parameters = list(pro=c(1,1),mean=mu,variance=variance),
                  seed = NULL)

cl <- simdat[,1]

## Not run: 
##D sigma <- array(apply(O, 3, function(x,y) crossprod(x*y), 
##D                  y = sqrt(scale*shape)), c(2,2,2))
##D paramList <- list(mu = mu, sigma = sigma)
##D coordProj( simdat, paramList = paramList, classification = cl)
## End(Not run)



