### Name: add.attrib
### Title: Adds Attributes to Object of Class 'mefa'
### Aliases: add.attrib
### Keywords: manip

### ** Examples

###Example 1: simple atrificial data

ss <- data.frame(
cbind(
c("sample1","sample1","sample2","sample2","sample3","sample4"),
c("species1","species1","species1","species2","species3","zero.count"),
c("male","female","male","female","male","male")
),
c(1, 2, 10, 3, 4, 1)
)
colnames(ss) <- c("sample.id", "species.id", "gender", "catch")

sampletab1 <- as.data.frame(rbind(
        c("sample3", "bad"),
        c("sample1", "not-so-bad"),
        c("sample2", "good"),
        c("sample4", "very-bad")))
colnames(sampletab1) <- c("sample", "quality")

sampletab2 <- as.data.frame(rbind(
        c("sample4", "debrecen", "nagyerdo", "bekasto", "2050-12-31", "bencike"),
        c("sample2", "pecs", "tettye", "mecsek", "1956-10-23", "barna"),
        c("sample1", "kiralyret", "bajdazoi", "bank", "2000-01-01", "XY"),
        c("sample3", "budapest", "pest", "rottenbiller", "2007-10-03", "SP")))
colnames(sampletab2) <- c("sample", "locality1", "locality2", "locality3", "date", "collector")

spectab <- as.data.frame(rbind(
        c("species3", "family1", "1"),
        c("species2", "family2", "5"),
        c("species1", "family1", "2"),
        c("species5", "family2", "1"),
        c("species4", "family1", "10")
))
colnames(spectab) <- c("species", "taxonomy", "size")

mf <- mefa(xct <- xcount(sscount(ss, zc="zero.count")),
xorder(xct, "samples", sampletab1, 1),
xorder(xct, "species", spectab, 1)
)

mf2 <- add.attrib(mf, "samples", sampletab2, 1)
mf2

### Example 2: field data of Villany Hills

## Not run: 
##D data(vtable, landsnail, vsample, vhabitat)
##D 
##D vmf <- mefa(
##D vt <- as.xcount(vtable, FALSE), 
##D xorder(vt, which="samples", vsample),
##D xorder(vt, which="species", landsnail[,1:4], 2)
##D )
##D 
##D extra <- landsnail[,c(2, 5:8)][order(rnorm(nrow(landsnail))),]
##D 
##D vmf2 <- add.attrib(vmf, which="species", extra, 1)
##D vmf2
## End(Not run)



