### Name: mefa
### Title: Makes Object of Class 'mefa'
### Aliases: mefa
### Keywords: manip

### ** Examples

### Example 1: simple atrificial data

ss <- data.frame(
cbind(
c("sample1","sample1","sample2","sample2","sample3","sample4"),
c("species1","species1","species1","species2","species3","zero.count"),
c("male","female","male","female","male","male")
),
c(1, 2, 10, 3, 4, 1)
)
colnames(ss) <- c("sample.id", "species.id", "gender", "catch")

spectab <- as.data.frame(rbind(
        c("species3", "family1", "1"),
        c("species2", "family2", "5"),
        c("species1", "family1", "2"),
        c("species5", "family2", "1"),
        c("species4", "family1", "10")
))
colnames(spectab) <- c("species", "taxonomy", "size")

sampletab <- as.data.frame(rbind(
        c("sample3", "bad"),
        c("sample1", "good"),
        c("sample2", "good"),
        c("sample4", "bad")))
colnames(sampletab) <- c("sample", "quality")

xct <- xcount(sscount(ss, zc="zero.count"))
xo1 <- xorder(xct, "samples", sampletab, 1)
xo2 <- xorder(xct, "species", spectab, 1)

mf1 <- mefa (xct, xo1, xo2)
mf1

mf2 <- mefa(xcount(sscount(ss, zc="zero.count"), 2), xo1, xo2)
mf2

### Example 2: field data of Villany Hills

## Not run: 
##D data(landsnail, vsample, vtable)
##D 
##D vt <- as.xcount(vtable, FALSE)
##D spec <- xorder(vt, which="species", landsnail, 2)
##D sampl <- xorder(vt, which="samples", vsample)
##D 
##D vmf <- mefa(vt, sampl, spec)
##D vmf
##D 
##D ### Example 3: field data of the dolina
##D 
##D data(dol.count, dol.sample, landsnail)
##D 
##D dmf <- mefa(
##D dxc <- xcount(sscount(fill.count(dol.count), zc="zero.count")),
##D xorder(dxc, which="samples", dol.sample),
##D xorder(dxc, which="species", landsnail, 2)
##D )
##D 
##D dmf
## End(Not run)



