### Name: report.mefa
### Title: Reports Object of Class 'mefa'
### Aliases: report.mefa
### Keywords: manip

### ** Examples

## Not run: 
##D data(landsnail, vhabitat, vsample, vtable)
##D 
##D vt <- as.xcount(vtable, FALSE)
##D spec <- xorder(vt, which="species", landsnail, 2)
##D sampl <- xorder(vt, which="samples", vsample)
##D vmf <- mefa(vt, sampl, spec)
##D v2 <- strify(vmf, strata = "site.descr", which = "samples")
##D habi <- xorder(v2, which="samples", vhabitat, 2)
##D vmf2 <- mefa(v2, habi, spec)
##D 
##D report.mefa("vspec-report.txt", vmf2, "species", c(3,2,4:7), "spec.name", "order", 0,
##D     FALSE, FALSE, sep = c(", "," (",")","; "))
##D 
##D report.mefa("vsampl-report.txt", vmf2,"samples", c(3,2,4:7), "spec.name", "order", 0,
##D     FALSE, FALSE, sep = c(", "," (",")",",\n"))
##D 
##D report.mefa("vspec-report.tex", vmf2,"species", c(3,2,4:7), "spec.name", "order", "author",
##D     TRUE, FALSE, sep = c(", "," (",")","; "))
##D 
##D report.mefa("vsampl-report.tex", vmf2,"samples", c(3,2,4:7), "spec.name", "order", "author",
##D     TRUE, TRUE, sep = c(", "," (",")",",\n"))
## End(Not run)



