### Name: strify
### Title: Stratifies Object of Class 'xcount' or 'mefa'
### Aliases: strify
### Keywords: manip

### ** Examples

## Not run: 
##D data(landsnail, vhabitat, vsample, vtable)
##D 
##D v1 <- as.xcount(vtable, FALSE, segment="mixed")
##D spec <- xorder(v1, which="species", landsnail, 2)
##D sampl <- xorder(v1, which="samples", vsample)
##D vmf <- mefa(v1, sampl, spec)
##D 
##D v2 <- strify(vmf, strata = "site.descr", which = "samples")
##D v2
##D 
##D check.attrib(v2, which="samples", vhabitat, 2)
##D habi <- xorder(v2, which="samples", vhabitat, 2)
##D vmf2 <- mefa(v2, habi, spec)
##D 
##D v3 <- strify(vmf2, strata = "familia", which = "species")
##D v3
## End(Not run)



