### Name: editMIM
### Title: Editing a mim model object
### Aliases: editmim testdelete retrieveMIMvalues
### Keywords: models

### ** Examples

data(rats)
gmd.rats <- as.gmData(rats)
m.main <- mim(".",  data=gmd.rats)
m2 <- editmim(m.main, addEdge=c("Sex:Drug", "Sex:W2"))
m3 <- editmim(m.main, addEdge=c("Sex:Drug", "Sex:W2"),haddEdge="Drug:W1:W2")

summary(m2)
summary(m3)

data(housing)

housingTab <- xtabs(Freq ~ Sat + Infl + Type + Cont, data = housing)
ht <- as.gmData(housingTab)

marg1 <- mim("Sat:Infl:Cont//", data=ht)
testdelete("Sat:Cont",marg1)

## Try deleting an edge not in the model:

testdelete("Sat:Type",marg1)

testdelete("Sat:Cont",marg1,arg="MJ")
testdelete("Sat:Cont",marg1,arg="M")




