### Name: regmixEM.chgpt
### Title: EM Algorithm for Mixtures of Regressions with a Changepoint
### Aliases: regmixEM.chgpt
### Keywords: file

### ** Examples

## EM output for simulated data.
 
w<-rbinom(100, 1, .5)
cpt<-50
x<-sort(runif(100, 0, 10))
x1<-cbind(1, x)
xt<-cbind(x1, (x-x[cpt])*(x>x[cpt]))
beta<-c(5, -1)
gamma<-c(15, -1, 2)
y<-w*rnorm(100, mean = xt%*%gamma, sd = .1) + 
   (1-w)*rnorm(100, mean = x1%*%beta, sd = .1)
out<-regmixEM.chgpt(y = y, x = x, t = cpt, beta = beta, 
                    gamma = gamma, verb = TRUE, epsilon = 1e-03)
out



