### Name: mokken-package
### Title: Mokken Scale Analysis in R
### Aliases: mokken-package mokken
### Keywords: package

### ** Examples


# Personality test
data(acl)               

# Select the items of the scale Communality
acl.com <- acl[,1:10]

# Compute scalability coefficients
coefH(acl.com)

# Investigate the assumption of monotonicity
monotonicity.com <- check.monotonicity(acl.com)
summary(monotonicity.com)
plot(monotonicity.com)

# Investigate the assumption of non-intersecting using method restscore
restscore.com <- check.restscore(acl.com)
summary(restscore.com)
plot(restscore.com)

# Investigate the assumption of non-intersecting using method pmatrix
pmatrix.com <- check.pmatrix(acl.com)
summary(pmatrix.com)
plot(pmatrix.com)

# Partition the entire data set into mokken scales
search.normal(acl.com)



