### Name: monoproc
### Title: Monotonizing procedure
### Aliases: monoproc monoproc,locfit,numeric,missing,missing-method
###   monoproc,locfit,numeric,missing,character-method
###   monoproc,locfit,numeric,numeric,missing-method
###   monoproc,locfit,numeric,list,character-method
###   monoproc,fit,missing,ANY,ANY-method
###   monoproc,loess,numeric,missing,missing-method
###   monoproc,loess,numeric,numeric,missing-method
###   monoproc,locpoly,numeric,missing,missing-method
###   monoproc,locpoly,numeric,numeric,missing-method
###   monoproc,ksmooth,numeric,missing,missing-method
###   monoproc,ksmooth,numeric,numeric,missing-method
###   monoproc,list,numeric,missing,missing-method
###   monoproc,list,numeric,missing,character-method
###   monoproc,list,numeric,numeric,missing-method
###   monoproc,list,numeric,list,character-method
### Keywords: regression nonparametric smooth

### ** Examples

#Spencer's Mortality Dataset
if(require(locfit)){
data(spencer)
attach(spencer)
fit<-locfit.raw(age,mortality, alpha=0.3, kern="epan")
fitmono<-monoproc(fit, bandwidth=0.0003, gridsize=30)
plot(age,mortality)
lines(fit)
lines(fitmono, col=2)}

#Fat Data to predict Bodyfat (two independent variables)
if(require(UsingR)&&require(locfit)){
data(fat)
fat<-fat[-39,] ##two extreme observations
fat<-fat[-41,] ##are deleted
attach(fat)
fit<-locfit.raw(cbind(weight, height),body.fat.siri, alpha=0.3, deg=1, kern="epan")
fitmono<-monoproc(fit,bandwidth=1,dir="xy", gridsize=30)
nf<- layout(matrix(c(1,1,1,2,2,3,3,3,4,4), 2, 5, byrow = TRUE))
layout.show(nf)
plot(fit, type="persp", theta = 135, phi = 30,col="lightblue",
        cex=0.7,main="unconstraint Bodyfat estimate")
plot(fit)
plot(fitmono,theta = 135, phi = 30, col="lightblue",cex=0.7, 
        main="monotone Bodyfat estimate")
plot(fitmono, type="contour")
t<-cv(fitmono)
CV<-sum((t[,2]-body.fat.siri)^2)/250    #Cross Validation for the unconstraint estimator
CV2<-sum((t[,1]-body.fat.siri)^2)/250   #Cross Validation for the monotone estimator
}

#Two Examples about the cars Data
#first example somehow trivial since the loess-fit is already monotone increasing
cars.lo <- loess(dist ~ speed, cars,
control = loess.control(surface = "direct"))
predict<-predict(cars.lo, data.frame(speed = seq(5, 30, 1)))
plot(cars.lo, xlab="speed", ylab="dist")
lines(seq(5, 30, 1),predict)
monofit<-monoproc(cars.lo, bandwidth=0.3, gridsize=40)
lines(monofit,col=2)

data(cars)
speed<-cars$speed
dist<-cars$dist
fit1<-ksmooth(speed, dist, "normal", bandwidth=2)
##computes the Nadaraya-Watson estimate
fit2<-monoproc(fit1,bandwidth=0.7)
##calculates the monotone estimates
         plot(speed, dist)
         lines(fit1, col=2)
         lines(fit2, col=3)

#Comparison with R-function isoreg
fit1<-ksmooth(speed, dist, "normal", bandwidth=2.5)
fit2<-monoproc(fit1,bandwidth=0.7)
fit3<-isoreg(speed,dist)

plot(fit3,plot.type="single", main="monotone regression", xlab="speed", ylab="distance")
  lines(fit1, col=3, lwd=1.5)
lines(fit2, lwd=1.5)
legend(5,100, c("isoreg","ksmooth","monoproc"),col=c(2,3,1), lty=c(1,1,1))




