### Name: multcompLetters
### Title: Letter summary of similarities and differences
### Aliases: multcompLetters
### Keywords: dplot

### ** Examples

dif3 <- c(FALSE, FALSE, TRUE)
names(dif3) <- c("A-B", "A-C", "B-C")
dif3L <- multcompLetters(dif3)
dif3L
print(dif3L)
print(dif3L, TRUE)

dif4 <- c(.01, .02, .03, 1)
names(dif4) <- c("a-b", "a-c", "b-d", "a-d")
(diff4.T <- multcompLetters(dif4))

(dif4.L1 <- multcompLetters(dif4,
       Letters=c("*", ".")))
# "Letters" can be any character strings,
# but they should be recognizable when
# concatonated.

x <- array(1:9, dim=c(3,3),
   dimnames=list(NULL, LETTERS[1:3]))
d3 <- dist(x)
multcompLetters(d3, threshold=2)



