### Name: playwith
### Title: An interactive plot GUI
### Aliases: playwith plotAndPlay
### Keywords: iplot dynamic

### ** Examples

## Not run: 
##D 
##D ## `playwith` a base graphics plot: interaction and annotation
##D ## -- from example(plot.default)
##D playwith(plot(cars$speed, cars$dist, xlab = "Speed", ylab = "Distance",
##D          panel.first = lines(lowess(cars$speed, cars$dist), lty = "dashed"),
##D          pch = 0, cex = 1.2, col = "blue"))
##D 
##D # you might get an error "Plot margins too small"; make window bigger and repeat
##D 
##D require(lattice)
##D 
##D ## multiple lattice panels; identify points with nice labels
##D playwith(xyplot(Income ~ log(Population / Area) | state.region, 
##D         data=data.frame(state.x77)))
##D 
##D ## same plot with 2 pages (2 panels per page); new plot window
##D playwith(xyplot(Income ~ log(Population / Area) | state.region, 
##D         data=data.frame(state.x77), layout=c(2,1)), name="other plot")
##D 
##D ## time series plot: navigate x-axis only, transform y-axis
##D treering2 <- window(treering, start=1)
##D playwith(plot(treering2), nav.scales="x", trans.scales="y", 
##D         labels=paste(time(treering2),"CE"), 
##D         extra.buttons=list("logscale"))
##D 
##D ## see what the current call is (for last focused plot window)
##D plotAndPlayGetState()$call
##D 
##D ## example of evaluating and storing arguments in the plot call
##D globalOne <- 1:10
##D localStuff <- function() {
##D         localOne <- 10:1
##D         playwith(plot(localOne, globalOne))
##D }
##D localStuff()
##D ## see which objects have been copied and stored with the plot
##D sapply(plotAndPlayGetState()$env, object.size)
##D 
##D ## brushing multivariate scatterplots, see help(panel.brush.splom)
##D playwith(splom(environmental))
##D 
##D ## simple spin and zoom for 3D plots
##D playwith(wireframe(volcano, drape=TRUE))
##D 
##D ## example of the 'layers' button with a panel function
##D ## -- from example(xyplot)
##D EE <- equal.count(ethanol$E, number=9, overlap=1/4)
##D playwith(xyplot(NOx ~ C | EE, data = ethanol,
##D        prepanel = function(x, y) prepanel.loess(x, y, span = 1),
##D        xlab = "Compression Ratio", ylab = "NOx (micrograms/J)",
##D        panel = function(x, y) {
##D            panel.grid(h=-1, v= 2)
##D            panel.xyplot(x, y)
##D            panel.loess(x,y, span=1)
##D        },
##D        aspect = "xy"))
##D 
##D ## a code chunk: no interaction, only annotation, saving, etc
##D ## -- from example(plot.default)
##D x <- 0:12
##D y <- sin(pi/5 * x)
##D playwith({
##D    op <- par(mfrow = c(3,3), mar = .1+ c(2,2,3,1))
##D    for (tp in c("p","l","b",  "c","o","h",  "s","S","n")) {
##D       plot(y ~ x, type = tp,
##D         main = paste("plot(*, type = \"",tp,"\")",sep=""))
##D       if(tp == "S") {
##D          lines(x,y, type = "s", col = "red", lty = 2)
##D          mtext("lines(*, type = \"s\", ...)", col = "red", cex=.8)
##D       }
##D    }
##D    par(op)
##D })
##D 
##D ## see help(plotAndPlayButtons) for examples of defining new buttons!
##D 
## End(Not run)



