### Name: plotAndPlayButtons
### Title: Utilities for plotAndPlayGTK buttons
### Aliases: plotAndPlayButtons plotAndPlayBasicButtons quickTool
###   plotAndPlayGetState plotAndPlaySetState plotAndPlayGetCurrState
###   plotAndPlaySetCurrState plotAndPlayGetCurrID plotAndPlaySetCurrID
###   plotAndPlayUpdate plotAndPlayDoFocus plotAndPlayMakePrompt
###   plotAndPlayUnmakePrompt plotAndPlaySetPrompt plotAndPlayGetToolbar
###   plotAndPlayGetDA plotAndPlaySetRawXLim plotAndPlaySetRawYLim unlogX
###   unlogY xy.coords.call
### Keywords: utilities

### ** Examples

## Not run: 
##D 
##D ## defining new buttons (and other widgets) for the toolbar...
##D 
##D require(lattice)
##D 
##D ## A kind of "OK" button: It gets the subscripts of currently labelled points 
##D ## (from 'identify') and passes them to a function: in this case, just 'print'.
##D showids_handler <- function(widget, user.data) {
##D         ids <- plotAndPlayGetState("ids")
##D         print(unique(unlist(ids)))
##D }
##D showids_button <- quote(quickTool("Show IDs", "gtk-yes", 
##D         tooltip="Print out indices of the selected points", f=showids_handler))
##D playwith(xyplot(Income ~ Population / Area, data=data.frame(state.x77)), 
##D         extra.buttons=list(showids_button))
##D 
##D ## A toggle button to add a smoothing line to xyplot
##D ## (assumes the 'type' argument will be passed to panel.xyplot)
##D smooth_handler <- function(widget, user.data) {
##D         tmp.state <- plotAndPlayGetState()
##D         # get the current 'type' argument
##D         plotType <- eval(tmp.state$call$type, tmp.state$env)
##D         if (is.null(plotType)) plotType <- "p"
##D         # remove "smooth" type if it is already there
##D         if (!is.na(i <- match("smooth", plotType))) plotType <- plotType[-i]
##D         # add "smooth" type if the toggle button is active
##D         if (widget["active"]) plotType <- c(plotType, "smooth")
##D         # update state
##D         tmp.state$call$type <- plotType
##D         plotAndPlaySetState(tmp.state)
##D         plotAndPlayUpdate()
##D }
##D smooth_button <- quote(quickTool("Smooth", "gtk-add", f=smooth_handler, 
##D         tooltip="Overlay loess smooth (with default span=2/3)", isToggle=T))
##D playwith(xyplot(sunspot.year ~ 1700:1988, type="l"), 
##D         extra.buttons=list(smooth_button))
##D 
##D ## Get the current plot limits and print them (works with lattice / traditional)
##D ## It would be simpler to grab the xlim/ylim arguments, but they might be NULL.
##D showlims_handler <- function(widget, user.data) {
##D         tmp.state <- plotAndPlayGetState()
##D         # get current plot limits
##D         if (tmp.state$is.lattice) {
##D                 # lattice plot
##D                 if (!any(tmp.state$focus)) {
##D                         trellis.focus("panel", 1, 1, highlight=F)
##D                 }
##D                 require(grid)
##D                 xlim <- convertX(unit(0:1, "npc"), "native", valueOnly=T)
##D                 ylim <- convertY(unit(0:1, "npc"), "native", valueOnly=T)
##D                 if (!any(tmp.state$focus)) trellis.unfocus()
##D         } else {
##D                 # traditional graphics plot
##D                 xlim <- par("usr")[1:2]
##D                 ylim <- par("usr")[3:4]
##D         }
##D         xlim <- unlogX(xlim, tmp.state$call, tmp.state$is.lattice)
##D         ylim <- unlogY(ylim, tmp.state$call, tmp.state$is.lattice)
##D         print(list(x=signif(xlim, 3), y=signif(ylim, 3)))
##D }
##D showlims_button <- quote(quickTool("Limits", "gtk-yes",
##D         tooltip="Print out current plot limits", f=showlims_handler))
##D playwith(stripplot(Sepal.Length ~ Species, iris, jitter=T, factor=0.3),
##D         extra.buttons=c(list("logscale", "zero"), showlims_button))
##D 
##D ## A more complex toolbar item:
##D ## A "spinbutton" to choose a number 'n', then group the data into 'n' clusters.
##D ## Should work with plot or xyplot.
##D my_cluster_handler <- function(widget, user.data) {
##D         tmp.state <- plotAndPlayGetState()
##D         n <- widget["value"]
##D         xy <- xy.coords.call(tmp.state$call, tmp.state$env)
##D         groups <- NULL
##D         if (n > 1) {
##D                 clusts <- kmeans(cbind(xy$x,xy$y), n)
##D                 labels <- paste("#", 1:n, " (n = ", clusts$size, ")", sep="")
##D                 groups <- factor(clusts$cluster, labels=labels)
##D         }
##D         # update state
##D         #tmp.state$call$groups <- groups
##D         # to avoid putting a big vector in the plot call, store in local env:
##D         assign("auto_groups", groups, envir=tmp.state$env)
##D         tmp.state$call$groups <- if (!is.null(groups)) quote(auto_groups)
##D         plotAndPlaySetState(tmp.state)
##D         plotAndPlayUpdate()
##D }
##D my_cluster_spinner <- quote({
##D         spinner <- gtkSpinButton(min=1, max=10, step=1)
##D         spinner["value"] <- 1
##D         gSignalConnect(spinner, "value-changed", my_cluster_handler)
##D         vbox <- gtkVBox()
##D         vbox$packStart(gtkLabel("Clusters:"))
##D         vbox$packStart(spinner)
##D         foo <- gtkToolItem()
##D         foo$add(vbox)
##D         foo
##D })
##D # need to generate random data outside the plot call, otherwise it changes!
##D xdata <- rnorm(100)
##D ydata <- rnorm(100) * xdata / 2
##D playwith(xyplot(ydata ~ xdata, aspect="iso", auto.key=list(space="right")), 
##D         extra.buttons=list(my_cluster_spinner))
##D 
## End(Not run)



