gap.plot               package:plotrix               R Documentation

_D_i_s_p_l_a_y _a _p_l_o_t _w_i_t_h _o_n_e _o_r _t_w_o _g_a_p_s (_m_i_s_s_i_n_g _r_a_n_g_e_s) _o_n _o_n_e _a_x_i_s

_D_e_s_c_r_i_p_t_i_o_n:

     Displays a plot with one or two missing ranges on one of the axes.

_U_s_a_g_e:

      gap.plot(x,y,gap,gap.axis="y",xticlab,xtics=NA,yticlab,ytics=NA,
       col=rep(par("col"),length(x)),xlim,ylim,pch=rep(1,length(x)),...)

_A_r_g_u_m_e_n_t_s:

     x,y: data values

     gap: the range(s) of values to be left out

gap.axis: whether the gaps are to be on the x or y axis

 xticlab: labels for the x axis ticks

   xtics: position of the x axis ticks

 yticlab: labels for the y axis ticks

   ytics: position of the y axis ticks

     col: color(s) in which to plot the values

xlim,ylim: the plot limits.

     pch: symbols to use in plotting.

     ...: arguments passed to 'plot'.

_D_e_t_a_i_l_s:

     Displays a plot omitting one or two ranges of values on one axis. 
     Typically used when there is a relatively large gap or two in the
     overall  range of one set of values, often because of outliers.
     The function warns the user if any values have been omitted by
     being in the "gap". See  'axis.break' for a brief discussion of
     plotting on  discontinuous coordinates.

     If at least four values are passed in 'gap', the first four will
     be used to calculate two "gaps" in the plot instead of one. The
     function does not check whether these values are sensible, so it
     is quite easy to ask for a very silly plot.

     The default ticks are usually not ideal, and most users will want
     to pass their own tick positions and perhaps labels.

_V_a_l_u_e:

     nil

_A_u_t_h_o_r(_s):

     Jim Lemon and Ben Bolker

_S_e_e _A_l_s_o:

     'gap.barplot'

_E_x_a_m_p_l_e_s:

      twogrp<-c(rnorm(5)+4,rnorm(5)+20,rnorm(5)+5,rnorm(5)+22)
      gpcol<-c(2,2,2,2,2,3,3,3,3,3,4,4,4,4,4,5,5,5,5,5)
      gap.plot(twogrp,gap=c(8,16),xlab="Index",ylab="Group values",
       main="Plot gap on Y axis",col=gpcol)
      gap.plot(twogrp,rnorm(20),gap=c(8,16),gap.axis="x",xlab="X values",
       xtics=c(4,7,17,20),ylab="Y values",main="Plot gap on X axis") 
     threegrp <- c(twogrp,rnorm(10)+40)
     gap.plot(threegrp,gap=c(8,16,25,35),
      xlab="X values",ylab="Y values",
      main="Test two gap plot",
      ytics=c(4,6,18,20,22,38,40),
      pch=c(rep(2,10),rep(3,10),rep(4,10)),
      col=c(rep(2,10),rep(3,10),rep(4,10)))

